/* gamemain2.c */
#include<scenario.h>
#include<screen.h>
#include<gameio.h>
#include<walls.h>
#include<stdio.h>
#include<enemy.h>
#include<enemy_yuriko.h>
#include<myenemy.h>
#include<enemyrika.h>
#include<movingobjectmanager.h>
#ifdef DEBUG
#include<log.h>
#endif

#define OBJNUM 2
#define MOBJNUM 9
#define EVNUM 8

object* objp[OBJNUM];
movingobject* mobjp[MOBJNUM];
event* ev[EVNUM];
vector2 mypos;
int isfire;
int score;

void onestepb(movingobject* mobj){
  vec2add(&(mobj->pos), &(mobj->vel));
}

void dispb(movingobject* mobj){
  putobject(*(mobj->obj), mobj->id, mobj->pos.x, mobj->pos.y);
}

void dispm(movingobject* mobj){
  putobject(*(mobj->obj), 0, mobj->pos.x, mobj->pos.y);
}

int bomba(movingobject* mobj){
  return 1;
}

void initobjects(void){
  objp[0] = newobject(1,1,"x");
  objp[1] = newobject(3,2," ^ =x=");
}

void initmovingobjects(void){
  mobjp[0] = newenemy();
  mobjp[1] = newmovingobject(&objp[0], onestepb, dispb, bomba, "bullet");
  mobjp[2] = newmovingobject(&objp[1], NULL, dispm, bomba, "me");
  mobjp[3] = originalenemy1(); //(ZAQ)
  mobjp[4] = originalenemy2(); //犬
  mobjp[5] = newenemy1(); //クラゲ
  mobjp[6] = newenemy2(); //魚
  mobjp[7] = newenemy3(); //ボス
  mobjp[8] = newenemy4(); //UFO
  /*mobjp[9] = ;*/
}

void setevents(void){
  int i;
  ev[0] = newevent( 5, makevector2(20,2),makevector2(0,0.1), mobjp[8],"plus0");
  ev[1] = newevent(10, makevector2(10,2),makevector2(0,0.1), mobjp[3],"plus1");
  ev[2] = newevent(20, makevector2(20,5),makevector2(0,0.1), mobjp[4],"plus2");
  ev[3] = newevent(25, makevector2(30,2),makevector2(0,0.1), mobjp[5],"plus3");
  ev[4] = newevent(30, makevector2(25,4),makevector2(0.25,0), mobjp[6],"plus4");
  ev[5] = newevent(40, makevector2(10,5),makevector2(0,0.1), mobjp[7],"plus4");
  ev[6] = newevent(50, makevector2( 5,3),makevector2(0,0.1), mobjp[0],"plus4");
  ev[7] = newevent(1000000, makevector2(10,1),makevector2(0,1), mobjp[0],"dummy");
  for(i=0;i<EVNUM;i++){
    addevent(ev[i]);
  }
  resetmark();
}

void init(void){
  initscreen();
  initwalls();
  initmom();
  initobjects();
  initmovingobjects();
  initscenario();
  setevents();
}


void getstate(vector2* ret, int* isfire){
  static vector2 pos = {SCREENWIDTH/2-1, SCREENHEIGHT-3}; 
  *isfire = 0;
  int in = gameioread();
  switch(in){
  case 'j':
  case 'J':
    pos.x++;
    break;
  case 'g':
  case 'G':
    pos.x--;
    break;
  case 'y':
  case 'Y':
    pos.y--;
    break;
  case 'b':
  case 'B':
    pos.y++;
    break;
  case 'u':
  case 'U':
    pos.x++;
    pos.y--;
    break;
  case 't':
  case 'T':
    pos.x--;
    pos.y--;
    break;
  case 'n':
  case 'N':
    pos.x++;
    pos.y++;
    break;
  case 'v':
  case 'V':
    pos.x--;
    pos.y++;
    break;
  case 'h':
  case 'H':
    *isfire = 1;
  } 
  *ret = pos;
}

void show(void){
  int x,y;
  for(y=0;y<SCREENHEIGHT;y++){
    for(x=0;x<SCREENWIDTH;x++){
      gameioput(x,y,dispbuffer[SCREENWIDTH*y+x]);
    }
  }
  gameiorefresh();
}

void gameloop(void){
  int speedlevel = 10; 
  int time = 0;
  int i=1;
  vector2 tmpv;
  event* e = getnextevent();
  while(1){
    gameiousleep(30000);
    if(time%speedlevel == 0){
      scrollwall();
      while(e!= NULL && e->time*speedlevel < time){
        addmo(e->mobj, e->pos, e->vel);
        e = getnextevent();
      }
      score++;
      if(score == 20*i){
	       speedlevel--;
	       i++;
      }
      printf("   【現在】 得点: %d    スピードレベル: %d\n",score,i);
    }
    getstate(&mypos, &isfire);
    gameioput(SCREENWIDTH+3,1,'0'+(int)mypos.x/10);
    gameioput(SCREENWIDTH+4,1,'0'+(int)mypos.x%10);
    gameioput(SCREENWIDTH+6,1,'0'+(int)mypos.y/10);
    gameioput(SCREENWIDTH+7,1,'0'+(int)mypos.y%10);
    putwalls(SCREENHEIGHT);
    putmo();
    onestepmo();
    if(checkcollision(mypos, objp[1])!=NONOBJ){
      score+=10;
      printf("HIT!!!\n");
      break;
    }
    if(isfire){
      tmpv = mypos;
      tmpv.x +=1;
      tmpv.y -=2;
      addmo(mobjp[1], tmpv, makevector2(0,-1));
    }
    mobjp[2]->pos = mypos;
    dispm(mobjp[2]);
    show();
    time++;
  }
}

int main(void){
  int i;

  printf("<ルール説明>\nこのゲームは流れてくるコースを避けながら上に進んでいくゲームです。\n途中で現れる敵にぶつかってもいけません。\n一定時間経過するとスピードが上がっていきます。\n\n");
   printf(" <操作方法>\nJ: 右 に移動\nG: 左 に移動\nY: 上 に移動\nB: 下 に移動\nU:右上に移動\nT:左上に移動\nN:右下に移動\nV:左下に移動\nH: 弾 を発射　(命中すると敵を倒すことができます)\n※キーボードが英数モードになっていないとプレーできません\n\n→始めるには1を押してください ");
   scanf("%d",&i);
   if(i==1){
     gameiousleep(100000);
     printf("よーい\n");
     gameiousleep(1000000);
     printf("どん!!\n");
     gameiousleep(1000000);

     gameioinit();
     gameioclear();
     init();
  
     score=0;
     gameloop();

     gameiopost();
     printf("【結果: %d点】\n",score);
     return 0;
   }
}
